# emphasing one pie

import pandas as pd
from collections import Counter
from matplotlib import pyplot as plt
import numpy as np
import csv

data = pd.read_csv('data.csv')
ids = data['Responder_id']
responses = data['LanguagesWorkedWith']

language_cnt = Counter()
for response in responses:
    language_cnt.update(response.split(";"))
    
languages = []
popularity = []
# 15 is too much for pie charts. 5 is more than enough
# 15 is good for bar charts
#for x in language_cnt.most_common(15):
for x in language_cnt.most_common(5):
    languages.append(x[0])
    popularity.append(x[1])

# use explode to offset the slices
# list of floats that measure how much we want to emphasize
# something. 
#   0 - no emphasis. 
#   x > 0 - the fraction of the radius by how much to emphasize (0.1 -> 10%)
explode = [0,0,0,0.1,0]
    
plt.figure(1)

# shadow to make it somewhat 3d
# startangle -> how much to rotate the first item in degrees
# autopct -> auto display percentage, requires format string as argument
plt.pie(popularity, labels=languages, explode=explode, wedgeprops={'edgecolor':'black'},
        shadow=True, startangle=90, autopct='%1.1f%%')

plt.title("Language popularity")
plt.tight_layout()
plt.savefig("pandas_pie_chart.png")
plt.show()